(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4367,        130]*)
(*NotebookOutlinePosition[      5081,        155]*)
(*  CellTagsIndexPosition[      5037,        151]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(D[\((b\ x^2 + \ c\ x + d)\)/\((\((x + 1)\) \((x^2 + 1)\))\), 
      x]\)], "Input"],

Cell[BoxData[
    \(\(c + 2\ b\ x\)\/\(\((1 + x)\)\ \((1 + x\^2)\)\) - \(2\ x\ \((d + c\ x \
+ b\ x\^2)\)\)\/\(\((1 + x)\)\ \((1 + x\^2)\)\^2\) - \(d + c\ x + b\ x\^2\)\/\
\(\((1 + x)\)\^2\ \((1 + x\^2)\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Together[\((\((x + 1)\)^2 \((x^2 + 1)\)^2)\) \((A/\((x + 
                  1)\) + \((M\ x + N)\)/\((x^2 + 
                  1)\) + \(c + 2\ b\ x\)\/\(\((1 + x)\)\ \((1 + x\^2)\)\) - \
\(2\ x\ \((d + c\ x + b\ x\^2)\)\)\/\(\((1 + x)\)\ \((1 + x\^2)\)\^2\) - \(d \
+ c\ x + b\ x\^2\)\/\(\((1 + x)\)\^2\ \((1 + x\^2)\)\))\)]\)], "Input"],

Cell[BoxData[
    \(A + c - d + N + A\ x + 2\ b\ x - 2\ d\ x + M\ x + 2\ N\ x + 
      2\ A\ x\^2 + b\ x\^2 - c\ x\^2 - 3\ d\ x\^2 + 2\ M\ x\^2 + 2\ N\ x\^2 + 
      2\ A\ x\^3 - 2\ c\ x\^3 + 2\ M\ x\^3 + 2\ N\ x\^3 + A\ x\^4 - b\ x\^4 + 
      2\ M\ x\^4 + N\ x\^4 + A\ x\^5 + M\ x\^5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Collect[%, x]\)], "Input"],

Cell[BoxData[
    \(A + c - d + 
      N + \((A + 2\ b - 2\ d + M + 2\ N)\)\ x + \((2\ A + b - c - 3\ d + 
            2\ M + 2\ N)\)\ x\^2 + \((2\ A - 2\ c + 2\ M + 
            2\ N)\)\ x\^3 + \((A - b + 2\ M + N)\)\ x\^4 + \((A + 
            M)\)\ x\^5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{A + c - d + N \[Equal] 8, 
        A + 2\ b - 2\ d + M + 2\ N \[Equal] 12, 
        2\ A + b - c - 3\ d + 2\ M + 2\ N \[Equal] 16, 
        2\ A - 2\ c + 2\ M + 2\ N \[Equal] 4, A - b + 2\ M + N \[Equal] 4, 
        A + M \[Equal] 0}, {A, M, N, b, c, d}]\)], "Input"],

Cell[BoxData[
    \({{A \[Rule] 0, M \[Rule] 0, N \[Rule] 3, b \[Rule] \(-1\), c \[Rule] 1, 
        d \[Rule] \(-4\)}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(La\ descomposici\[OAcute]n\ por\ el\ m\[EAcute]todo\ de\ hermite\ es\ \
como\ sigue\)], "Input"],

Cell[BoxData[
    \(\(4  x\^4 + 4  x\^3 + 16  x\^2 + 12  x + 8\)\/\(\(\((x + 1)\)\^2\) \((x\
\^2 + 1)\)\^2\) = 
      3\/\(x\^2 + 1\) + \(\(d\/dx\) \((\(\(-x\^2\) + x - 4\)\/\(\((x + 1)\) \
\((x\^2 + 1)\)\))\)\(\[IndentingNewLine]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Comprobaci\[OAcute]n\)\(:\)\(\[IndentingNewLine]\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Together[
      3\/\(x\^2 + 1\) + 
        D[\(\(-x\^2\) + x - 4\)\/\(\((x + 1)\) \((x\^2 + 1)\)\), 
          x]]\)], "Input"],

Cell[BoxData[
    \(\(4\ \((2 + 3\ x + 4\ x\^2 + x\^3 + x\^4)\)\)\/\(\((1 + x)\)\^2\ \((1 + \
x\^2)\)\^2\)\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{499, 369},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CelfTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 55, 103, 1, 30, "Input"],
Cell[1845, 55, 220, 3, 48, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2102, 63, 356, 5, 109, "Input"],
Cell[2761, 70, 799, 4, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2797, 79, 46, 1, 30, "Input"],
Cell[2846, 82, 278, 2, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3153, 92, 294, 5, 70, "Input"],
Cell[3450, 99, 133, 2, 29, "Output"]
}, Open  ]],
Cell[3598, 104, 116, 2, 30, "Input"],
Cell[3717, 108, 247, 4, 70, "Input"],
Cell[3967, 114, 89, 1, 50, "Input"],

Cell[CellGroupData[{
Cell[4081, 119, 147, 4, 47, "Input"],
Cell[4231, 125, 120, 2, 48, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

